﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public static class EligibilityValidatorFactory
    {
        static List<string> gulfWarNames =  new List<string> { "IRAQ", "KUWAIT", "SAUDI ARABIA", "BAHRAIN", "OMAN", "QATAR", "UNITED ARAB EMIRATES", "GULF OF ADEN", "GULF OF OMAN", "RED SEA", "PERSIAN GULF", "ARABIAN SEA" };
        static List<string> gulfWarCodes = new List<string> { "IZ", "KU", "SA", "BA", "MU", "QA", "AE", "6D", "6M", "6E", "6P", "6R" };
        public static FirstGulfWarValidator CreateFirstGulfWarValidator()
        {
            return new FirstGulfWarValidator(
                 gulfWarNames
                 ,gulfWarCodes,
                 new DateRange(DateTime.Parse("01/01/1990"), DateTime.Parse("09/30/1991"))
            );
        }
        public static AHOBPREligibilityValidator CreateAHOBPREligibilityValidator()
        {
            //Use the gulf war names and codes because both validators need them. Then insert the additions.
            var validator = new AHOBPREligibilityValidator(
                                        gulfWarNames, 
                                        gulfWarCodes, 
                                        new DateRange(DateTime.Parse("01/01/1990"), DateTime.Now));
            validator.Codes.AddRange(new List<string> { "AF", "DJ" });
            validator.Names.AddRange(new List<string> { "AFGHANISTAN", "DJIBOUTI" });
            return validator;
        }
    }
}
